// The Eprom info dialog box callback function

// Windows Header Files:
#include <windows.h>

// C RunTime Header Files
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>

#include "resource.h"
#include "CU30Wrap.h"

//#include "DllLoader.h"
//#include "USBDllLoader.h"
typedef struct delphiIEE
{
  DWORD USBVendorID;
  DWORD USBProductID;
  DWORD USBDeviceID;
  DWORD DeviceID;
  DWORD EEPromID;
  DWORD Version;
  DWORD SerialNumber;
  DWORD CustomerID;
  char  Company[32];
  char  Date[32];
  char  ProductStr[32];
  char  Customer[32];
  char  CustomerStr[32];
} USBEEProm;
extern HINSTANCE hInst;								// current instance
USBEEProm sourceData;
// Mesage handler for the dialog box.
LRESULT CALLBACK tEpromPanel(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
	{
		case WM_INITDIALOG:
      SetDlgItemInt(hDlg,IDC_EEPROMID,sourceData.EEPromID,FALSE);
      SetDlgItemInt(hDlg,IDC_DEVICEID,sourceData.DeviceID,FALSE); 
      SetDlgItemInt(hDlg,IDC_SERIAL,  sourceData.SerialNumber,FALSE); 
      SetDlgItemText(hDlg,IDC_COMPANY,sourceData.Company);
      SetDlgItemText(hDlg,IDC_PRODUCT,sourceData.ProductStr); 
      SetDlgItemText(hDlg,IDC_DATE,   sourceData.Date); 
      SetDlgItemText(hDlg,IDC_CUSTOMER,sourceData.Customer);
		return TRUE;  
    case WM_COMMAND:
      if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
				EndDialog(hDlg, LOWORD(wParam));			
    return TRUE;
	}
  return FALSE;
}

void OpenEpromPanel (HWND hWnd, DWORD USBInstance,DWORD USBVersion,DWORD DevID,DWORD EEID)
{

    int val = CU30WGetEEpromInfo(USBInstance,USBVersion,DevID,EEID,
    &sourceData.USBVendorID,&sourceData.USBProductID,&sourceData.USBDeviceID,
    &sourceData.DeviceID,&sourceData.EEPromID,&sourceData.Version,
    &sourceData.SerialNumber,&sourceData.CustomerID,
    sourceData.Company,sourceData.Date,sourceData.ProductStr,sourceData.Customer,sourceData.CustomerStr);
    DialogBox(hInst, (LPCTSTR)IDD_DIALOG2, NULL, (DLGPROC)tEpromPanel);    

}
